VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "Magn1"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = True
Option Explicit

Implements QFWB.ExploringObject
Implements QFWB.Asynchronous


''' Current problem solved flag
Private Solved As Boolean
''' Current model shapes meshed flag
Private Meshed As Boolean
''' Current model saved flag
Private Saved As Boolean
''' Current model built flag
Private Built As Boolean

''' Terminating flag
Private Cancel As Boolean



''' Initialize global variables
Private Sub Class_Initialize()
    theName = "Magn1"
End Sub


''' Make all initialization
Private Sub ExploringObject_Init(M As QFWB.Messenger)
    ''' Clear Cancel flag
    Cancel = False

    ''' Clear old references
    Set Prb = Nothing
    Set QF = Nothing

    ''' Init global flags
    Solved = False: Saved = False: Meshed = False: Built = False

    ''' Create input parameters storing object
    Set theParameters = ExploringObject_Parameters

    ''' Store Messenger object in global variable
    Set Mess = M
    Mess.State "Initializing ExploringObject", Cancel
    If Cancel Then Exit Sub

    ''' Check work folder existance
    On Error GoTo NoWorkFolder
    ChDir ExploringObject_Path & "\Magn1_Files"
    On Error GoTo 0

ResumeWorkFolder:

    ''' Init problem basic data
    InitLabels
    If Cancel Then Exit Sub

    ''' Launch QuickField
    On Error GoTo NoQuickField
    Set QF = New QuickField.Application
    If QF Is Nothing Then GoTo NoQuickField

    ''' Catch unknown server errors
    On Error GoTo ServerError

    ''' Check for 'Magn1' problem already opened
CheckProblemExist:
    Set Prb = QF.Problems(theName)
    If Not Prb Is Nothing Then
        Set Prb = Nothing
        Mess.Error wbProblemAlreadyOpened, "Problem '" & theName & "' already opened by QuickField. Click Yes to close that problem. Otherwise click No after you will close that problem manually.", Cancel
        ''' if Cancel = False then check problem existance again
        If Not Cancel Then GoTo CheckProblemExist
        Exit Sub
    End If

    ''' Check for 'Magn1' model already opened
    Dim Mdl As QuickField.Model
CheckModelExist:
    Set Mdl = QF.Models(theName)
    If Not Mdl Is Nothing Then
        Set Mdl = Nothing
        Mess.Error wbModelAlreadyOpened, "Model '" & theName & "' already opened by QuickField. Click Yes to close that model. Otherwise click No after you will close that model manually.", Cancel
        ''' if Cancel = False then check model existance again
        If Not Cancel Then GoTo CheckModelExist
        Exit Sub
    End If

    ''' Create new QuickField problem
    Set Prb = QF.Problems.Add

    ''' Set main problem parameters
    Prb.ProblemType = qfMagnetostatics
    Prb.Class = qfPlaneParallel
    Prb.Coordinates = qfCartesian
    Prb.LengthUnits = qfCentimeters

    Prb.ReferencedFile(qfModelFile) = ExploringObject_Path & "\" & theName & "_Files\" & theName & ".mod"
    Prb.ReferencedFile(qfDataFile) = ExploringObject_Path & "\" & theName & "_Files\" & theName & ".dms"

    ''' Saving problem
    Prb.SaveAs ExploringObject_Path & "\" & theName & "_Files\" & theName & ".pbm"

    Mess.State "Ready", Cancel
    Exit Sub

NoWorkFolder:
    Mess.Error wbCritical Or wbNoWorkFolder, "Error: Folder '" & ExploringObject_Path & "\" & theName & "_Files' not found.", Cancel
    Exit Sub

NoQuickField:
    Mess.Error wbCritical Or wbErrorQFLaunch, "Error: Cann't launch QuickField", Cancel
    Exit Sub

ServerError:
    Mess.Error wbCritical Or wbServerError, "", Cancel
    Exit Sub
End Sub


''' Get all input parameters
Private Property Get ExploringObject_Parameters() As QFWB.Parameters
    Dim thePrms As New QFWB.Parameters

    ''' ----------------------------------------
    ''' Start input parameters definition
    ''' AddNew parameters: IsGeometrical, IsPostprocess, Description, Notation, Unit, Value
    thePrms.AddNew True, False, "Air Gap", "airGap", "cm", 10
    thePrms.AddNew False, False, "Coercive Force", "Hc", "A/m", 147218
    thePrms.AddNew True, False, "Keeper Height", "keeperHeight", "cm", 10
    thePrms.AddNew True, False, "Keeper Width", "KeeperWidth", "cm", 40
    thePrms.AddNew True, False, "Magnet Height", "magnetHeight", "cm", 10
    thePrms.AddNew True, False, "Magnet Width", "magnetWidth", "cm", 10
    thePrms.AddNew True, False, "Yoke Height", "yokeHeight", "cm", 10
    thePrms.AddNew True, False, "Yoke Width", "yokeWidth", "", 40
    ''' End input parameters definition
    ''' ----------------------------------------

    Set ExploringObject_Parameters = thePrms
End Property

''' Set all input parameters
Private Property Set ExploringObject_Parameters(Prms As QFWB.Parameters)
    Set theParameters = Prms
End Property


''' Init problem basic data
Public Sub InitLabels()
    On Error GoTo ErrorInitLabels
    ''' Copy basic data file onto work data file
    FileCopy ExploringObject_Path & "\" & theName & "_Files\" & theName & "_Basic.dms", ExploringObject_Path & "\" & theName & "_Files\" & theName & ".dms"
    Exit Sub

ErrorInitLabels:
    Mess.Error wbCritical Or wbErrorCopyData, "Error: Cann't copy basic data file '" & ExploringObject_Path & "\" & theName & "_Files\" & theName & ".dms'.", Cancel
End Sub


''' Return output parameter names
Private Property Get ExploringObject_ResultNames() As QFWB.Parameters
    ''' Clear Cancel flag
    Cancel = False

    ''' Parameter names collection
    Dim Prms As New QFWB.Parameters

    ''' ----------------------------------------
    ''' Start output parameter names definition
    Prms.AddResult "Flux density"
    Prms.AddResult "Mechanical force"
    ''' End output parameter names definition
    ''' ----------------------------------------

    ''' Set function return value
    Set ExploringObject_ResultNames = Prms
End Property


''' Getting parameter minima
Private Function PrmMin(Prms As QFWB.Parameters, ParamName As String, ByRef Min As Double, ByRef ErrMsg As String) As Boolean
    Select Case ParamName
    ''' ----------------------------------------
    ''' TODO : Correct next code for setting minimum valid parameter values
    '''        For each parameter you must set:
    '''    Min = <minimum valid value>
    '''    ErrMsg = <Error string if parameter validation failed>
    '''    PrmMin = <True - if minimum depends on another input parameter value>
    Case "Air Gap"
        Min = 1
        ErrMsg = "Air Gap parameter minimum validation error"
        PrmMin = False
    Case "Coercive Force"
        Min = 50000
        ErrMsg = "Coercive Force parameter minimum validation error"
        PrmMin = False
    Case "Keeper Height"
        Min = 5
        ErrMsg = "Keeper Height parameter minimum validation error"
        PrmMin = False
    Case "Keeper Width"
        Min = 20
        ErrMsg = "Keeper Width parameter minimum validation error"
        PrmMin = False
    Case "Magnet Height"
        Min = 5
        ErrMsg = "Magnet Height parameter minimum validation error"
        PrmMin = False
    Case "Magnet Width"
        Min = 5
        ErrMsg = "Magnet Width parameter minimum validation error"
        PrmMin = False
    Case "Yoke Height"
        Min = 5
        ErrMsg = "Yoke Height parameter minimum validation error"
        PrmMin = False
    Case "Yoke Width"
        Min = 20
        ErrMsg = "Yoke Width parameter minimum validation error"
        PrmMin = False
    ''' ----------------------------------------
    End Select
End Function


''' Getting parameter maxima
Private Function PrmMax(Prms As QFWB.Parameters, ParamName As String, ByRef Max As Double, ByRef ErrMsg As String) As Boolean
    Select Case ParamName
    ''' ----------------------------------------
    ''' TODO : Correct next code for setting maximum valid parameter values
    '''        For each parameter you must set:
    '''    Max = <maximum valid value>
    '''    ErrMsg = <Error string if parameter validation failed>
    '''    PrmMax = <True - if maximum depends on another input parameter value>
    Case "Air Gap"
        Max = 20
        ErrMsg = "Air Gap parameter maximum validation error"
        PrmMax = False
    Case "Coercive Force"
        Max = 200000
        ErrMsg = "Coercive Force parameter maximum validation error"
        PrmMax = False
    Case "Keeper Height"
        Max = 20
        ErrMsg = "Keeper Height parameter maximum validation error"
        PrmMax = False
    Case "Keeper Width"
        Max = 100
        ErrMsg = "Keeper Width parameter maximum validation error"
        PrmMax = False
    Case "Magnet Height"
        Max = 20
        ErrMsg = "Magnet Height parameter maximum validation error"
        PrmMax = False
    Case "Magnet Width"
        Max = 20
        ErrMsg = "Magnet Width parameter maximum validation error"
        PrmMax = False
    Case "Yoke Height"
        Max = 20
        ErrMsg = "Yoke Height parameter maximum validation error"
        PrmMax = False
    Case "Yoke Width"
        Max = 100
        ErrMsg = "Yoke Width parameter maximum validation error"
        PrmMax = False
    ''' ----------------------------------------
    End Select
End Function



''' TODO:
''' Usually you need not to modify any of the next subroutines


''' Input parameters validation
Private Function ExploringObject_Validate(Prms As QFWB.Parameters, ByRef ErrMsg As String) As Boolean
    Dim Prm As QFWB.FixParameter
    Dim MinMax As Double

    For Each Prm In Prms
        PrmMin Prms, Prm.Description, MinMax, ErrMsg
        If Prm.Value < MinMax Then
            ExploringObject_Validate = False
            Exit Function
        End If
        PrmMax Prms, Prm.Description, MinMax, ErrMsg
        If Prm.Value > MinMax Then
            ExploringObject_Validate = False
            Exit Function
        End If
    Next Prm
    ExploringObject_Validate = True
End Function


''' Getting parameter value boundaries
Private Function ExploringObject_GetMinMax(Prms As QFWB.Parameters, ParamName As String) As QFWB.VarParameter
    Dim VarPrm As New QFWB.VarParameter
    Dim MinMax As Double
    Dim ErrMsg As String

    VarPrm.Description = ParamName
    PrmMin Prms, ParamName, MinMax, ErrMsg
    VarPrm.Min = MinMax
    PrmMax Prms, ParamName, MinMax, ErrMsg
    VarPrm.Max = MinMax
    Set ExploringObject_GetMinMax = VarPrm
    Set VarPrm = Nothing
End Function


''' This file author
Private Property Get ExploringObject_Author() As String
    ExploringObject_Author = "Tera Analysis Ltd."
End Property


''' ExploringObject name
Private Property Get ExploringObject_Name() As String
    ExploringObject_Name = theName
End Property


''' This implementation version
Private Property Get ExploringObject_Version() As String
    ExploringObject_Version = "1.0"
End Property


''' Sketch picture
Private Property Get ExploringObject_Sketch() As String
    ExploringObject_Sketch = ExploringObject_Path & "\" & theName & "_Files\" & theName & ".gif"
End Property


''' Project (running DLL) folder
Private Property Get ExploringObject_Path() As String
    ExploringObject_Path = App.Path
End Property


''' Get QuickField Application visibility
Private Property Get ExploringObject_Visible() As Boolean
    ''' Catch unknown server errors
    On Error GoTo ServerError

    ExploringObject_Visible = QF.MainWindow.Visible
    Exit Property

ServerError:
    Mess.Error wbServerError, "Getting QuickField visibility property caused an error.", Cancel
End Property


''' Set QuickField Application visibility
Private Property Let ExploringObject_Visible(NewState As Boolean)
    ''' Catch unknown server errors
    On Error GoTo ServerError

    QF.MainWindow.Visible = NewState
    Exit Property

ServerError:
    Mess.Error wbServerError, "Setting QuickField visibility property caused an error.", Cancel
End Property


''' Set input parameter values (do not edit)
Private Sub SetInputValues(Prms As QFWB.Parameters)
    Dim Prm As QFWB.FixParameter

    For Each Prm In Prms
        If Prm.Value <> theParameters(Prm.Description).Value Then
            theParameters(Prm.Description).Value = Prm.Value
            If Not Prm.IsPostProcess Then
                Solved = False
            End If
            If Prm.IsGeometry Then
                Built = False: Meshed = False: Saved = False
            End If
            If (Not Prm.IsGeometry) And (Not Prm.IsPostProcess) Then
                SetLabel Prm.Description
            End If
        End If
    Next Prm
End Sub


''' Build QuickField problem model
Private Sub BuildModel()
    ''' Catch unknown server errors
    On Error GoTo ServerError

    ''' Current QF Model object
    Dim Mdl As QuickField.Model
    ''' Current QF Result object
    Dim Res As QuickField.Result

    ''' Delete old QF Result document
    Set Res = Prb.Result
    If Not Res Is Nothing Then Res.Close
    Set Res = Nothing

    ''' Delete old model
    Mess.State "Deleting old model", Cancel
    If Cancel Then Exit Sub
    Set Mdl = Prb.Model
    If Not Mdl Is Nothing Then
        Mdl.Shapes.RemoveMesh
        Mdl.Close False
    End If
    Set Mdl = Nothing

    ''' Get new model object
    Mess.State "Loading new model", Cancel
    If Cancel Then Exit Sub
    Prb.LoadModel

    ''' Customize model
    ModifyModel
    If Cancel Then Exit Sub

    ''' Set Built flag to avoid unnecessary building
    Built = Not Prb.Model Is Nothing
    ''' Set other flags
    If Built Then
        Meshed = (Prb.Model.Shapes.Meshed = qfAllMeshed)
        Saved = Prb.Model.Saved
    Else
        Meshed = False
        Saved = False
    End If

    Mess.State "Ready", Cancel
    Exit Sub

ServerError:
    Mess.Error wbCritical Or wbServerError, "Model building caused QuickField error.", Cancel
End Sub


''' Mesh all model shapes
Private Sub MeshModel()
    ''' Catch unknown server errors
    On Error GoTo ServerError

    ''' Current QF Model object
    Dim Mdl As QuickField.Model

    ''' Loading geometrical model
    Mess.State "Loading model", Cancel
    If Cancel Then Exit Sub
    Set Mdl = Prb.Model
    If Mdl Is Nothing Then
        Prb.LoadModel
        Set Mdl = Prb.Model
    End If

    ''' Build new model mesh
    Mess.State "Building mesh", Cancel
    If Cancel Then Exit Sub
    If Mdl.Shapes.Meshed <> qfAllMeshed Then Mdl.Shapes.BuildMesh

    ''' Set Meshed flag to avoid unnecessary meshing
    Meshed = (Mdl.Shapes.Meshed = qfAllMeshed)

    Mess.State "Ready", Cancel
    Exit Sub

ServerError:
    Mess.Error wbCritical Or wbServerError, "Model shapes meshing caused QuickField error.", Cancel
End Sub


''' Save geometrical model
Private Sub SaveModel()
    ''' Catch unknown server errors
    On Error GoTo ServerError

    ' Save current meshed model
    Mess.State "Saving model", Cancel
    If Cancel Then Exit Sub

    ''' Current QF Model object
    Dim Mdl As QuickField.Model

    ''' Get QF model object
    Set Mdl = Prb.Model
    If Mdl Is Nothing Then Exit Sub

    If Not Mdl.Saved Then Mdl.Save

    ''' Set Saved flag to avoid unnecessary saving
    Saved = Mdl.Saved

    Mess.State "Ready", Cancel
    Exit Sub

ServerError:
    Mess.Error wbCritical Or wbServerError, "Model saving caused QuickField error.", Cancel
End Sub


''' Solving current QF problem
Private Sub SolveProblem()
    ''' Catch unknown server errors
    On Error GoTo ServerError

    ''' Save problem - necessary to solve
    Prb.Save

    Mess.State "Solving problem", Cancel
    If Cancel Then Exit Sub

    ''' Unload model before solving to free memory
    ''' TODO: You can delete next 4 lines
    Dim Mdl As QuickField.Model
    Set Mdl = Prb.Model
    If Not Mdl Is Nothing Then Mdl.Close True
    Set Mdl = Nothing

    ''' Solving by QuickField
    Prb.SolveProblem

    ''' Set Solved flag to avoid unnecessary solving
    Solved = True

    Mess.State "Ready", Cancel
    Exit Sub

ServerError:
    Mess.Error wbCritical Or wbServerError, "Problem solving caused QuickField error.", Cancel
End Sub


''' Get output parameter values
Private Sub ExploringObject_GetResult(Prms As QFWB.Parameters, Pt As QFWB.ResultPoint)
    ''' Clear Cancel flag
    Cancel = False

    ''' Catch unknown server errors
    On Error GoTo ServerError

    Mess.State "Getting result", Cancel
    If Cancel Then Exit Sub

    ''' Update input parameter values and flags
    SetInputValues Prms

    ''' Build QF model
ModelBuilding:
    If Not Built Then BuildModel
    If Cancel Then Exit Sub
    ''' Check model existance
    If Prb.Model Is Nothing Then
        Mess.Error wbModelNotLoaded, "", Cancel
        ''' If Cancel = False then try to build model again
        If Not Cancel Then
            Built = False
            GoTo ModelBuilding
        End If
        Exit Sub
    End If
    If Cancel Then Exit Sub

    ''' Mesh model
ShapesMeshing:
    If Not Meshed Then MeshModel
    If Cancel Then Exit Sub
    ''' Check model shapes meshed
    If Prb.Model.Shapes.Meshed <> qfAllMeshed Then
        Mess.Error wbShapesNotMeshed, "", Cancel
        ''' If Cancel = False then try to mesh shapes again
        If Not Cancel Then
            Meshed = False
            GoTo ShapesMeshing
        End If
        Exit Sub
    End If
    If Cancel Then Exit Sub

    ''' Save model
ModelSaving:
    If Not Saved Then SaveModel
    If Cancel Then Exit Sub
    ''' Check model shapes meshed
    If Not Prb.Model.Saved Then
        Mess.Error wbShapesNotMeshed, "", Cancel
        ''' If Cancel = False then try to save model again
        If Not Cancel Then
            Saved = False
            GoTo ModelSaving
        End If
        Exit Sub
    End If
    If Cancel Then Exit Sub

    ''' Solve problem
ProblemSolving:
    If Not Solved Then SolveProblem
    If Cancel Then Exit Sub
    ''' Check problem solved
    If Not Prb.Solved Then
        Mess.Error wbProblemNotSolved, "", Cancel
        ''' If Cancel = False then try to solve problem again
        If Not Cancel Then
            Solved = False
            GoTo ProblemSolving
        End If
        Exit Sub
    End If
    If Cancel Then Exit Sub


    ''' Create QF Postprocessor View to getting result
    Mess.State "Creating QF Postprocessor View", Cancel
    If Cancel Then Exit Sub

    Prb.AnalyzeResults

    ''' Calculate output parameters
    Calculations Pt
    Exit Sub

ServerError:
    Mess.Error wbCritical Or wbServerError, "Getting result caused QuickField error.", Cancel
End Sub


''' Make all deinitialization (do not edit)
Private Sub Class_Terminate()
    ''' Catch all errors
    On Error Resume Next

    ''' Current QF Model object
    Dim Mdl As QuickField.Model

    If Not Mess Is Nothing Then
        Mess.State "Deinitializing ExploringObject", Cancel
    End If

    ''' Delete global references
    If Not Prb Is Nothing Then
        ''' Close model
        Set Mdl = Prb.Model
        If Not Mdl Is Nothing Then Mdl.Close False
        Set Mdl = Nothing

        ''' Close problem
        Prb.Close False
        Set Prb = Nothing
    End If

    ''' Close QuickField application
    If Not QF Is Nothing Then QF.Quit
    Set QF = Nothing

    If Not Mess Is Nothing Then
        Mess.State "Ready", Cancel
    End If
End Sub



''' Asynchronous solving functions implementation


''' Solving problem without getting result
Private Sub Asynchronous_Solve(ByVal Prms As QFWB.Parameters)
    ''' Clear Cancel flag
    Cancel = False

    ''' Update input parameter values and flags
    SetInputValues Prms

    ''' Checking dependencies
    If Built Then GoTo ModelLoading

    ''' Forget old QF Result document
    Dim Res As QuickField.Result
    Set Res = Prb.Result
    If Not Res Is Nothing Then Res.Close
    Set Res = Nothing

    ''' QF Model object
    Dim Mdl As QuickField.Model

    ''' Delete old model
    Mess.State "Deleting old model", Cancel
    If Cancel Then Exit Sub
    Set Mdl = Prb.Model
    If Not Mdl Is Nothing Then
        Mdl.Shapes.RemoveMesh
        Mdl.Close False
    End If
    Set Mdl = Nothing

    ''' Get new model object
ModelLoading:
    Mess.State "Opening new model", Cancel
    If Cancel Then Exit Sub
    Mess.AsyncLoadModel
    Exit Sub

End Sub


''' Asynchronous solving continue
Private Sub Asynchronous_Loaded()
    ''' Clear Cancel flag
    Cancel = False

    ''' Customize model
    If Not Built Then ModifyModel
    If Cancel Then Exit Sub

    ''' Check model existance
    If Prb.Model Is Nothing Then
        Mess.Error wbModelNotLoaded, "", Cancel
        If Not Cancel Then
            Built = False: Meshed = False: Saved = False: Solved = False
            Mess.AsyncLoadModel
        End If
        Exit Sub
    End If

    ''' Set Built flag to avoid unnecessary building
    Built = True

    ''' Create model shapes mesh
    Mess.State "Building mesh", Cancel
    If Cancel Then Exit Sub

    ''' Checking dependencies
    If Meshed Then
        Asynchronous_Meshed
        Exit Sub
    End If

    Mess.AsyncBuildMesh
End Sub


''' Asynchronous solving continue
Private Sub Asynchronous_Meshed()
    ''' Clear Cancel flag
    Cancel = False

    ''' Check meshing
    If Prb.Model.Shapes.Meshed <> qfAllMeshed Then
        Mess.Error wbShapesNotMeshed, "", Cancel
        If Not Cancel Then
            Meshed = False: Saved = False: Solved = False
            Mess.AsyncBuildMesh
        End If
        Exit Sub
    End If

    ''' Set Meshed flag to avoid unnecessary meshing
    Meshed = True

    ''' Save current model
    Mess.State "Saving model", Cancel
    If Cancel Then Exit Sub

    ''' Checking dependencies
    If Saved Then
        Asynchronous_Saved
        Exit Sub
    End If

    Mess.AsyncSaveModel
End Sub


''' Asynchronous solving continue
Private Sub Asynchronous_Saved()
    ''' Clear Cancel flag
    Cancel = False

    ''' Check model saving
    If Not Prb.Model.Saved Then
        Mess.Error wbModelNotSaved, "", Cancel
        If Not Cancel Then
            Saved = False: Solved = False
            Mess.AsyncSaveModel
        End If
        Exit Sub
    End If

    ''' Set Saved flag to avoid unnecessary building
    Saved = True

    ''' Resolving problem
    Mess.State "Solving problem", Cancel
    If Cancel Then Exit Sub

    ''' Checking dependencies
    If Solved Then
        Asynchronous_Solved
        Exit Sub
    End If

    If Not Solved Then Mess.AsyncSolve
End Sub


''' Asynchronous solving continue
Private Sub Asynchronous_Solved()
    ''' Clear Cancel flag
    Cancel = False

    ''' Check problem solving
    If Not Prb.Solved Then
        Mess.Error wbProblemNotSolved, "", Cancel
        If Not Cancel Then
            Solved = False
            Mess.AsyncSolve
        End If
        Exit Sub
    End If

    ''' Set Solved flag to avoid unnecessary solving
    Solved = True

    Mess.State "Ready", Cancel
    ''' Notify WorkBench about solving end
    Mess.Done
End Sub


''' Asynchronous solving continue
Private Sub Asynchronous_Calculated(ByVal List As Variant)
    ''' TODO: You can use this subroutine in optimizing integrals calculating

    ''' Notify WorkBench about solving end
    Mess.Done
End Sub


